--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A rotation in quaternion representation.
--- @class niQuaternion
--- @operator mul(niQuaternion): niQuaternion
--- @operator unm: niQuaternion
--- @field w number The W component of the quaternion.
--- @field x number The X component of the quaternion.
--- @field y number The Y component of the quaternion.
--- @field z number The Z component of the quaternion.
niQuaternion = {}

--- Creates a new identity quaternion.
--- @return niQuaternion quaternion No description yet available.
function niQuaternion.identity() end

--- Creates a new niQuaternion object.
--- @param w? number *Default*: `0`. No description yet available.
--- @param x? number *Default*: `0`. No description yet available.
--- @param y? number *Default*: `0`. No description yet available.
--- @param z? number *Default*: `0`. No description yet available.
--- @return niQuaternion quaternion No description yet available.
function niQuaternion.new(w, x, y, z) end

--- Creates a copy of the quaternion.
--- @return niQuaternion result No description yet available.
function niQuaternion:copy() end

--- Calculates the dot product between this quaternion and another.
--- @param other niQuaternion The other quaternion.
--- @return number result The dot product result.
function niQuaternion:dot(other) end

--- Calculates the exponential e^q.
--- @return number result The result.
function niQuaternion:exp() end

--- Fill the quaternion by converting an angle-axis rotation. The angle must be within the interval [0, PI] and the axis must be unit length.
--- @param angle number No description yet available.
--- @param axis tes3vector3 No description yet available.
function niQuaternion:fromAngleAxis(angle, axis) end

--- Fill the quaternion by converting a rotation matrix.
--- @param matrix tes3matrix33 No description yet available.
function niQuaternion:fromRotation(matrix) end

--- Inverting or conjugating a rotation quaternion has the effect of reversing the axis of rotation, which modifies it to rotate in the opposite direction from the original. That is, if an object is rotated to a new position using a quaternion, then rotating it again by quaternion's inverse will return it to its original location.
--- @return niQuaternion result No description yet available.
function niQuaternion:invert() end

--- Calculates the logarithm log(q).
--- @return number result The result.
function niQuaternion:log() end

--- Normalizes the quaternion to unit length in-place. Returns true if result is unit length, false if the quaternion magnitude is very near to zero and cannot be normalized.
--- @return boolean isNormalized If the quaternion was successfully normalized.
function niQuaternion:normalize() end

--- Returns a normalized copy of this quaternion. The quaternion will be all zero if the quaternion magnitude is very near to zero and cannot be normalized.
--- @return niQuaternion result The normalized quaternion.
function niQuaternion:normalized() end

--- Calculates a spherical linear interpolation between this quaternion and another, limited to a maximum rotation angle. Chooses the shortest path of interpolation between quaternions, which means it minimizes spin but the interpolation arc is limited to pi radians or 180 degrees of interpolation.
--- @param target niQuaternion The quaternion to interpolate towards.
--- @param rotationLimit number The interpolation result will be limited to this maximum angle from the initial quaternion. Angle in radians.
--- @return niQuaternion result The calculated result.
function niQuaternion:rotateTowards(target, rotationLimit) end

--- Calculates a spherical linear interpolation between this quaternion and another. Chooses the shortest path of interpolation between quaternions, which means it minimizes spin but the interpolation arc is limited to pi radians or 180 degrees of interpolation.
--- @param target niQuaternion The quaternion to interpolate towards.
--- @param transition number The interpolation parameter. Must be between `0.0` (closer to this quaternion) and `1.0` (closer to the other quaternion).
--- @return niQuaternion result The calculated result.
function niQuaternion:slerp(target, transition) end

--- Calculates a spherical linear interpolation between this quaternion and another. Does not choose a direction of interpolation. This means the interpolation arc can be up to 2pi radians or 360 degrees, depending on the signs of the quaternions.
--- @param target niQuaternion The quaternion to interpolate towards.
--- @param transition number The interpolation parameter. Must be between `0.0` (closer to this quaternion) and `1.0` (closer to the other quaternion).
--- @return niQuaternion result The calculated result.
function niQuaternion:slerpKeyframe(target, transition) end

--- Convert this quaternion into an angle-axis rotation.
--- @return number angle No description yet available.
--- @return tes3vector3 axis No description yet available.
function niQuaternion:toAngleAxis() end

--- Convert this quaternion into a rotation matrix.
--- @return tes3matrix33 result No description yet available.
function niQuaternion:toRotation() end

